
-- ------------------------------------------------------------
mEmitSpeed = 64.00;
mScale = 0.4;
mBlendMode = kBlendNormal;
--mBlendMode = kBlendAdditiveAlpha;
mEffectDuration = 1.3;
--mTextureName = "coins.xml";
mTextureName = "coin2";
mMaxParticles = 50.40;

-- ------------------------------------------------------------
-- Define our particle characteristics
-- ------------------------------------------------------------
pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member


-- Set the particle texture
SetTexture(mTextureName);

-- Set the blend mode
SetBlendMode(mBlendMode);

-- LAST, we set the total number of particles in the particle
-- system. This doesn't 'create' the particles, but rather
-- allocates a block of 'dead' particles that can be created
-- below.
SetNumParticles(mMaxParticles);


-- ------------------------------------------------------------
-- Initialization rules.
-- 
-- The following rules define how particles are created.
--
-- Any parameter below in initialization or animation rules that 
-- is a scalar, Color(), or Vec2() can alternaly take a function 
-- that returns the same type--and most functions can take any type
-- and will return that same type. The exception is any function
-- that's expecting a scalar in certain parameter positions.

-- Define dLocus for FluidFX; in the game it's defined in 
-- swarm.cpp as a data source, and it gets the mouse position.
if not dLocus then
   dLocus= Vec2(0,0) ; 
end

gDuration = mEffectDuration;

-- Pick a position randomly, within a range of values.
-- dLocus is defined in swarm.cpp and added to the random
-- range
pPosition:Init( fRange( Vec2(-20,-10), Vec2(20,0) )+dLocus );

-- Pick a velocity within a range
pVelocity:Init( fRange( Vec2(-70,-200), Vec2(70,-300) ) + Vec2(0,-250) );

-- Start scale at 0.5
pScale:Init( mScale );

-- Start age as 0 milliseconds
pAge:Init(0);

-- Start initial rotation as a random angle
pSpin:Init( fRange( 0, 2*3.1415927 ) );

-- Start spin velocity random from -10 to 10
pSpinSpeed:Init( fRange( 3, 8 ) * fPick(1,-1) );

-- ------------------------------------------------------------
-- Particle Parameter Animation Functions
--
-- The following rules define how particles animate.
-- Each rule is applied on each frame of animation.

-- Add velocity scaled by time to position
pPosition:Anim( pPosition + fTimeScale(pVelocity) );

-- Add 1/second to scale
pScale:Anim( pScale + fTimeScale(0.5) );

-- Add gravity scaled by time to velocity
pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,780)) );

-- Fade (using age) from white to yellow to black. Assumes
-- the first parameter is a number of elapsed milliseconds,
-- though can work to linearly interpolate using first 
-- scalar parameter between any value types.
pColor:Anim( 
   fFade( pAge,
      Color(1,1,1,0), mEffectDuration*180,
      Color(1,1,1,1), mEffectDuration*700,
      Color(1,1,1,1), mEffectDuration*220,
      Color(1,1,0,0) ) -- to final color
   );

-- Spin by pSpinSpeed scaled by time
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

-- Set the particle's "Up" vector to the current user variable
-- "pSpin"
pUp:Anim( f2dRotation( pSpin ) );

-- Age the particle using age function
pAge:Anim( pAge+fAge() );

-- General Anim functions
-- Expire particles over 700 ms old
Anim( fExpire( fGreater(pAge,mEffectDuration*1200) ) );

-- ------------------------------------------------------------
-- Create initial particles (optional)
-- CreateParticles( 1 );

-- ------------------------------------------------------------

-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
   gDuration = gDuration - seconds;
   if ( gDuration > 0.0 ) then
      CreateParticles( seconds * mEmitSpeed );
   end
end
